function [ H_est, se_d, nse_d, se_r, nse_r ] = UEUplinkChannelEstimation( Y, G_est, Phi, P, options, H_d, H_r )
%UEUPLINKCHANNELESTIMATION Summary of this function goes here
%   Detailed explanation goes here
Y_mat = zeros(options.M*options.N_slot,options.K);
G_equ = zeros(options.M*options.N_slot,options.N+options.M);
for n = 1:options.N_slot
    Y_mat((n-1)*options.M+1:n*options.M,:) = Y(:, n, :)/sqrt(options.Tx_power);
    G_equ((n-1)*options.M+1:n*options.M,:) = [eye(options.M) G_est*diag((Phi(:,n).'))];
end
H_est = inv(G_equ'*G_equ)*G_equ'*Y_mat*P'/options.K;

se_d = norm(H_d - H_est(1:options.M,:), 'fro')^2;
nse_d = se_d/norm(H_d, 'fro')^2;
%% calculate the squared error under the existence of sign ambiguity
se_r = 0;
for j = 1:options.N
    se_r = se_r + min(norm(H_r(j,:)-H_est(options.M+j,:), 'fro'), norm(H_r(j,:)+H_est(options.M+j,:), 'fro'))^2;
end
nse_r = se_r/norm(H_r,'fro')^2;

end